<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CServices extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "services") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					if ($this->tpl_module["settings"]["set_style"] == "1") {
						return $this->Category();
					} else {
						return $this->Landing();
					}
				break;

				case "category":
					return $this->Category();
				break;

			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"category"				=> "category.htm",
			"images"				=> "images.htm",

			"landing"				=> "landing.htm",

		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Category() {
		global $base ,$_CONF;

		if ($_GET["cat_url"]) {
			$cat = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:services_cats']} as c,
					{$this->tables['plugin:services_cats_lang']} as l
				WHERE
					c.module_id={$this->tpl_module[mod_id]} AND 
					c.cat_id = l.cat_id AND 
					c.cat_status = 1 AND 
					l.lang_id = {$this->tpl_module[lang_id]} AND 
					c.cat_link_type = 4 AND 
					l.cat_url LIKE '%s'
				",
				array(
					$_GET["cat_url"]
				)
			);
		} else {
			$cat = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:services_cats']} as c,
					{$this->tables['plugin:services_cats_lang']} as l
				WHERE
					c.module_id={$this->tpl_module[mod_id]} AND 
					c.cat_id = l.cat_id AND 
					c.cat_status = 1 AND 
					c.cat_link_type = 4 AND 
					l.lang_id = {$this->tpl_module[lang_id]} 
				ORDER BY 
					c.cat_order ASC 
				LIMIT 1
				"
			);

			$this->detected = true;

			$_GET["cat_url"] = $cat["cat_url"];
		}

		
		if (!is_array($cat) && ($_GET["sub"] == "category")) {

			if ($this->detected) {
				return "";
			}
			
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}

		$text = $this->pageTitleBlock(array(
			$this->tpl_module["link"] => $this->tpl_module["mod_name"],
			$this->tpl_module["link"] . $cat["cat_url"] . "/" => $cat["cat_title"],
		));

				
		$this->module->plugins["seo"]->PageMeta($cat);

		$this->module->plugins["seo"]->Canonical($this->tpl_module["link"] . $cat["cat_url"] . "/");

		$template = &$this->private->templates["category"];
		

		$cat["link"] = $this->tpl_module["link"] . $cat["cat_url"] . "/";


		$this->SetComments($this->tpl_module["settings"]["set_comments_details"], array("link" => $cat["link"]));

		$this->plugins["seo"]->OpenGraph(array(
			"og:title"	=> $cat["cat_title"],
			"og:type"	=> "article",
			"og:image"	=> $cat["cat_image"] ? $_CONF["url"] . "upload/summaries/cat_{$cat[cat_id]}.jpg" : "",
			"og:url"	=> $this->tpl_module["link"] . $cat["cat_url"] . "/",
		));


		switch ($cat["cat_res_type"]) {
			case "1":
				$image = $template->blockReplace("Image"  , $cat );
			break;

			case "2":
				$image = $template->blockReplace("Youtube"  , $cat );
			break;

			case "3":
				$image = $template->blockReplace("Vimeo"  , $cat );
			break;
		}
		

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$cat["cat_layout"] ? $cat["cat_layout"] : $this->tpl_module["settings"]["set_layout_details"],
				$this->tpl_module["mod_protected"]
			),

			is_array($cat) ? $template->blockREplacE(
				"Main" ,
				$cat , 
				array(
					"image"		=> $image,
					"images"	=> $this->CatImages($cat),

					"title"		=> $cat["cat_description_title"] ? $template->blockReplace("Title" , $cat) : "",

					"social_links" => $this->plugins["socialmedia"] && $this->tpl_module["settings"]["set_social_details"] ? $this->plugins["socialmedia"]->Share($cat["link"]) : "",

				),
				$text, 
				$this->tpl_module,
				$this->tpl_module["settings"]
			) : ""
		);


	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function CatImages($cat) {
		global $base;

		if (!is_array($cat)) {
			return "";
		}
		
		$images = $this->plugins["media"]->Gallery(
			$cat["cat_id"] , 
			$cat["module_id"] , 
			"" , 
			"" , 
			"array" , 
			array(
				"path" => "upload/services",
				"tn"	=> $this->tpl_module["settings"]["set_images_height"] ? "tn" : "tn2"
			)
		);


		if (!is_array($images)) {
			return "";
		}
		


		return $base->html->Table(
			$this->private->templates["images"] , 
			"", 
			$images

		);

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {
		global $base;

		$text = $this->pageTitleBlock();				
		$this->module->plugins["seo"]->PageMeta($text);


		$template = &$this->private->templates["landing"];

		$cats = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:services_cats']} as c,
				{$this->tables['plugin:services_cats_lang']} as l
			WHERE
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_id = l.cat_id AND 
				c.cat_status = 1 AND 
				l.lang_id = {$this->tpl_module[lang_id]} 

			ORDER BY
				c.cat_order ASC
			"
		);


		$cats = $this->processItems($cats , $template);
		
		$this->SetComments($this->tpl_module["settings"]["set_comments"], array("link" => $this->tpl_module["link"]));

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),

			$template->blockREplacE(
				"Main" , 
				array(
					"items"		=> $base->html->table(
						$template,
						"" , 
						$cats
					),

					"_title"	=> $text["text_block_1_title"] ? $template->blockReplace("MainTitle" , $text) : "",

				), 
				$text,				
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);


	}
	
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($cats , $template , $module = null) {

		if (!$module) {
			$module = $this->tpl_module;
		}		


		if (is_array($cats)) {
			foreach ($cats as $key => $val) {
				$val["_link"] = $module["link"] . $val["cat_url"] . "/";
				$cats[$key]["icon"] = $template->blockREplace($val["cat_icon"] ? "Icon" : "NoIcon" , $val);

				$link = $btn = $style = "";


		

				switch ($val["cat_link_type"]) {

					case "1":
					case "2":
					case "3":

						$link = $this->plugins["modules"]->BuildLink(array(
							"type"	=> $val["cat_link_type"],
							"link"	=> $val["cat_link_link"],
							"module"=> $val["cat_link_module"],
							"global"=> $val["cat_link_global"]
						));

						$btn = $val["cat_link_text"];
						$style = $val["cat_link_style"];

					break;

					case "4":
						$link = $val["_link"];
						$btn = "{LANG_MORE}";
						$style = $module["mod_settings"] ? $module["mod_settings"]["set_button_style"]: $module["settings"]["set_button_style"];
					break;

					default:
					break;
				}
				

				if ($link) {
					$cats[$key]["button"] = $template->blockReplace(
						"Button",
						array(
							"size"	=> $module["mod_settings"] ? $module["mod_settings"]["set_button_size"] : $module["settings"]["set_button_size"],
							"style"	=> $style,

							"link"	=> $link , 
							"text"	=> $btn,
							
						)
					);	
					$val["link"] = $link;

					$cats[$key]["title"] = $template->blockReplace("TitleLink" , $val);
				} else {
					$cats[$key]["button"] = "";
					$cats[$key]["title"] = $template->blockReplace("Title" , $val);
				}


				$cats[$key]["image"] = "";

				switch ($val["cat_tn_type"]) {
					//image
					case "1":
						$cats[$key]["image"] = $val["cat_tn_image"] ? $template->blockREplace("TnImage" .($link ? "Link" : "") , $val) : "";
					break;

					//icon
					case "2":
						$cats[$key]["image"] = $val["cat_tn_icon"] ? $template->blockREplace("TnIcon" .($link ? "Link" : "") , $val) : "";
					break;
				}
				
			}			
		}

		return $cats;
	}

	function GetMenuButton($module) { 


		switch ($module["settings"]["set_menu_style"]) {
			default:
				return parent::GetMenuButton($module);
			break;

			case "1":
				$items = $this->GetCatsWithLinks($module["mod_id"]);

				if (is_array($items)) {
					foreach ($items as $key => $val) {
						$sub[] = array(
							"title"		=> $val["cat_title"],
							"link"		=> $val["link"],
							"selected"	=> $val["selected"],
							"target"	=> "",

							"html"		=> "",
							"sub"		=> "",

						);
					}
					


				}

				return parent::GetMenuButton(
					$module , 
					array( 
						"html"	=> $this->plugins["menus"]->dropDownHTML(								
							array(
								"size"		=> $module["settings"]["set_menu_cols"],
								"id"		=> $module["mod_id"],
								"bg"		=> $module["settings"]["set_menu_bg"],
								"title"		=> $module["mod_name"],
							),
							$sub
						)
					)
				);
			
			break;

		}				
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetCatsWithLinks($mod_id) {
		global $_LANG_ID;

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:services_cats']} as i,
				{$this->tables['plugin:services_cats_lang']} as il
			WHERE 				
				i.cat_id = il.cat_id AND 
				il.lang_id={$_LANG_ID} AND 
				i.module_id={$mod_id} AND 
				cat_status = 1 AND 
				cat_link_type > 0 

			ORDER BY  cat_order ASC" 
		);


				
		if (is_array($items)) {	

			foreach ($items as $key => $val) {
				$link = "";

				switch ($val["cat_link_type"]) {

					case "1":
					case "2":
					case "3":

						$link = $this->module->plugins["modules"]->BuildLink(array(
							"type"	=> $val["cat_link_type"],
							"link"	=> $val["cat_link_link"],
							"module"=> $val["cat_link_module"],
							"global"=> $val["cat_link_global"]
						));
					break;

					case "4":
						$link = $this->plugins["modules"]->modules[$mod_id]["link"] . $val["cat_url"] . "/";
					break;
				}

				$items[$key]["link"] = $link;
				$items[$key]["selected"] = ($val["cat_url"] == $_GET["cat_url"]) && ($_GET["module_id"] == $val["module_id"]) ? true : "";
			}			
		}


		return $items;
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SitemapGetMaps($module , $lang) {

		if ($module["mod_id"]) {
			return array($module["mod_id"] => true);
		} else {
			return array($module["module_code"] => true);
		}
		
	}



	function SitemapGetLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);


		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:services_cats']} as c,
				{$this->tables['plugin:services_cats_lang']} as l
			WHERE
				c.module_id={$module[mod_id]} AND 
				c.cat_id = l.cat_id AND 
				c.cat_status = 1 AND 
				cat_link_type = 4 AND
				l.lang_id = {$module[lang_id]} 
			"
		);


		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$links[] = array(
					"url" => $module["link"] . $val["cat_url"] . "/",
				);
			}
			
		}

	}

}

?>